/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.plugin;

import de.willuhn.io.FileFinder;
import de.willuhn.io.FileUtil;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.MenuItemXml;
import de.willuhn.jameica.gui.NavigationItemXml;
import de.willuhn.jameica.gui.extension.Extension;
import de.willuhn.jameica.gui.extension.ExtensionRegistry;
import de.willuhn.jameica.gui.internal.action.PluginUnInstall;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.messaging.BootMessage;
import de.willuhn.jameica.messaging.PluginMessage;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.Dependency;
import de.willuhn.jameica.plugin.ExtensionDescriptor;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.plugin.PluginSource;
import de.willuhn.jameica.plugin.Version;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.services.ClassService;
import de.willuhn.jameica.services.PluginSourceService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.MultipleClassLoader;
import de.willuhn.util.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PluginLoader {
    private static final Set<String> obsoletePlugins = new HashSet<String>(){
        {
            this.add("jameica.scripting");
            this.add("jameica.update");
        }
    };
    private List<Manifest> plugins = new ArrayList<Manifest>();
    private Map<Manifest, Throwable> initErrors = new HashMap<Manifest, Throwable>();
    private Settings updateChecker = null;

    public synchronized void init() {
        String name;
        this.updateChecker = new Settings(PluginLoader.class);
        this.updateChecker.setAttribute("jameica", Application.getManifest().getVersion().toString());
        Application.getCallback().getStartupMonitor().setStatusText("init plugins");
        Logger.info((String)"init plugins");
        PluginSourceService service = (PluginSourceService)Application.getBootLoader().getBootable(PluginSourceService.class);
        List<PluginSource> sources = service.getSources();
        HashMap<String, Manifest> cache = new HashMap<String, Manifest>();
        for (PluginSource source : sources) {
            List<File> dirs = source.find();
            if (dirs == null) continue;
            for (File f : dirs) {
                try {
                    File mf = new File(f, "plugin.xml");
                    if (!mf.canRead() || !mf.isFile()) {
                        Logger.error((String)("no manifest found in " + f.getAbsolutePath() + ", skipping directory"));
                        continue;
                    }
                    Manifest m = new Manifest(mf);
                    m.setPluginSource(source.getType());
                    if (this.isObsolete(m.getName())) {
                        Logger.info((String)("found obsolete plugin " + m.getName() + " - skipping"));
                        try {
                            if (!source.canWrite()) continue;
                            this.markForDelete(m);
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable to auto-uninstall obsolete plugin, notifying user", (Throwable)e);
                            I18N i18n = Application.getI18n();
                            BootMessage msg = new BootMessage(i18n.tr("Das Plugin \"{0}\" wird nicht mehr ben\u00f6tigt.", m.getName()));
                            msg.setTitle(i18n.tr("Plugin deinstallieren"));
                            msg.setIcon("user-trash-full.png");
                            msg.setComment(i18n.tr("Das Plugin \"{0}\" wird nicht mehr ben\u00f6tigt da es jetzt bereits in Jameica enthalten ist. Bitte deinstallieren Sie es.", m.getName()));
                            msg.addButton(new Button(i18n.tr("Plugin deinstallieren..."), new PluginUnInstall(), m));
                            Application.getMessagingFactory().getMessagingQueue("jameica.boot").queueMessage(msg);
                        }
                        continue;
                    }
                    Manifest first = (Manifest)cache.get(m.getName());
                    if (first != null) {
                        Logger.warn((String)("found second plugin \"" + m.getName() + "\" in " + f + " (already installed in " + first.getPluginDir() + ") ignoring the older one"));
                        int compare = first.getVersion().compareTo(m.getVersion());
                        String toDelete = null;
                        if (compare == 0) {
                            Logger.warn((String)("have both the same version " + first.getVersion() + ", ignoring " + m.getPluginDir()));
                            toDelete = m.getPluginDir();
                        } else if (compare < 0) {
                            Logger.warn((String)(m.getPluginDir() + " (" + m.getVersion() + ") is newer than " + first.getPluginDir() + " (" + first.getVersion() + "), ignoring the older one"));
                            toDelete = first.getPluginDir();
                            cache.put(m.getName(), m);
                            this.plugins.remove(first);
                            this.plugins.add(m);
                        } else {
                            Logger.warn((String)(first.getPluginDir() + " (" + first.getVersion() + ") is newer than " + m.getPluginDir() + " (" + m.getVersion() + "), ignoring the older one"));
                            toDelete = m.getPluginDir();
                        }
                        I18N i18n = Application.getI18n();
                        BootMessage msg = new BootMessage(i18n.tr("Das Plugin \"{0}\" wurde doppelt installiert.", m.getName()));
                        msg.setTitle(i18n.tr("Plugin doppelt installiert"));
                        msg.setIcon("dialog-warning-large.png");
                        msg.setComment(i18n.tr("Bitte l\u00f6schen Sie den Ordner {0}", toDelete));
                        Application.getMessagingFactory().getMessagingQueue("jameica.boot").queueMessage(msg);
                        continue;
                    }
                    cache.put(m.getName(), m);
                    this.plugins.add(m);
                }
                catch (Throwable t) {
                    Logger.error((String)("unable to load manifest from " + f.getAbsolutePath()), (Throwable)t);
                }
            }
        }
        if (cache.size() == 0) {
            Logger.info((String)"*** no plugins installed ***");
            return;
        }
        Logger.info((String)"sort plugins by dependency");
        QuickSort.quickSort(this.plugins);
        for (int i = 0; i < this.plugins.size(); ++i) {
            Manifest mf = this.plugins.get(i);
            Logger.info((String)("  " + mf.getName()));
        }
        for (Manifest mf : this.plugins) {
            name = mf.getName();
            try {
                this.loadPlugin(mf);
            }
            catch (Throwable t) {
                if (t instanceof ApplicationException) {
                    Logger.error((String)("unable to load plugin " + name + ": " + t.getMessage()));
                } else {
                    Logger.error((String)("unable to load plugin  " + name), (Throwable)t);
                }
                this.initErrors.put(mf, t);
            }
        }
        for (Manifest mf : this.plugins) {
            if (!mf.isLoaded()) continue;
            name = mf.getName();
            try {
                this.initPlugin(mf);
            }
            catch (Throwable t2) {
                ApplicationException t2;
                if (t2 instanceof ApplicationException) {
                    Logger.error((String)("unable to init plugin " + name + ": " + t2.getMessage()));
                } else if (t2 instanceof OperationCanceledException) {
                    Logger.info((String)("plugin " + name + " skipped: " + t2.getMessage()));
                } else {
                    Logger.error((String)("unable to init plugin " + name), (Throwable)t2);
                }
                if (t2 instanceof NoSuchMethodError) {
                    t2 = new ApplicationException(Application.getI18n().tr("Inkompatibel mit aktueller Jameica-Version"), t2);
                }
                this.initErrors.put(mf, t2);
                if (t2 instanceof OperationCanceledException || Application.inStandaloneMode() || Application.inClientMode()) continue;
                I18N i18n = Application.getI18n();
                BootMessage msg = new BootMessage(i18n.tr("Das Plugin \"{0}\" kann nicht initialisiert werden. {1}", new String[]{name, t2.getMessage()}));
                msg.setTitle(i18n.tr("Plugin-Fehler"));
                msg.setIcon("dialog-warning-large.png");
                msg.setComment(t2.getMessage());
                Application.getMessagingFactory().getMessagingQueue("jameica.boot").queueMessage(msg);
            }
        }
        if (this.getInstalledPlugins().size() == 0) {
            Application.getMessagingFactory().getMessagingQueue("jameica.error").sendMessage(new QueryMessage("no plugin could be loaded successfully"));
        }
    }

    private void loadPlugin(Manifest manifest) throws Exception {
        if (manifest.isInstalled()) {
            Logger.debug((String)"plugin already initialized, skipping");
            return;
        }
        Logger.info((String)("loading plugin " + manifest.getName() + " [Version: " + manifest.getVersion() + "]"));
        Dependency jameica = manifest.getJameicaDependency();
        if (!jameica.check()) {
            throw new ApplicationException(Application.getI18n().tr("Plugin {0} ist abh\u00e4ngig von {1}, welches jedoch nicht in dieser Version installiert ist", new String[]{manifest.getName(), jameica.toString()}));
        }
        Dependency[] deps = manifest.getDependencies();
        if (deps != null && deps.length > 0) {
            for (int i = 0; i < deps.length; ++i) {
                Logger.info((String)("  resolving " + (deps[i].isRequired() ? "required" : "optional") + " dependency " + deps[i]));
                if (deps[i].check()) continue;
                throw new ApplicationException(Application.getI18n().tr("Plugin {0} ist abh\u00e4ngig von Plugin {1}, welches jedoch nicht installiert ist", new String[]{manifest.getName(), deps[i].toString()}));
            }
        }
        ClassService cs = (ClassService)Application.getBootLoader().getBootable(ClassService.class);
        MultipleClassLoader loader = cs.prepareClasses(manifest);
        manifest.setClassLoader(loader);
    }

    private void initPlugin(Manifest manifest) throws Exception {
        if (manifest.isInstalled()) {
            Logger.debug((String)"plugin already initialized, skipping");
            return;
        }
        Application.getCallback().getStartupMonitor().setStatusText("init plugin " + manifest.getName() + " [Version: " + manifest.getVersion() + "]");
        Logger.info((String)("init plugin " + manifest.getName() + " [Version: " + manifest.getVersion() + "]"));
        String pluginClass = manifest.getPluginClass();
        if (pluginClass == null || pluginClass.length() == 0) {
            throw new ApplicationException(Application.getI18n().tr("Plugin {0} enth\u00e4lt keine g\u00fcltige Plugin-Klasse (Attribut class in plugin.xml", manifest.getName()));
        }
        Plugin plugin = manifest.getPluginInstance();
        String versionKey = null;
        if (plugin == null) {
            Logger.info((String)("trying to initialize " + pluginClass));
            Class clazz = manifest.getClassLoader().load(pluginClass);
            BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            plugin = (Plugin)beanService.get(clazz);
            manifest.setPluginInstance(plugin);
            versionKey = clazz.getName();
        } else {
            versionKey = manifest.getName();
        }
        String s = this.updateChecker.getString(versionKey + ".version", null);
        if (s == null) {
            Logger.info((String)"Plugin started for the first time. Starting install");
            Application.getCallback().getStartupMonitor().setStatusText("installing plugin " + manifest.getName());
            plugin.install();
            Application.getCallback().getStartupMonitor().addPercentComplete(10);
        } else {
            Version oldVersion = new Version(s);
            Version newVersion = manifest.getVersion();
            if (oldVersion.compareTo(newVersion) < 0) {
                Logger.info((String)("detected update from version " + oldVersion + " to " + newVersion + ", starting update"));
                Application.getCallback().getStartupMonitor().setStatusText("updating plugin " + manifest.getName());
                plugin.update(oldVersion);
                Application.getCallback().getStartupMonitor().addPercentComplete(10);
            }
        }
        Application.getCallback().getStartupMonitor().setStatusText("initializing plugin " + manifest.getName());
        plugin.init();
        Application.getServiceFactory().init(manifest);
        Application.getCallback().getStartupMonitor().addPercentComplete(10);
        this.updateChecker.setAttribute(versionKey + ".version", manifest.getVersion().toString());
        Logger.info((String)"register plugin extensions");
        Application.getCallback().getStartupMonitor().setStatusText("register plugin extensions");
        ExtensionDescriptor[] ext = manifest.getExtensions();
        if (ext != null && ext.length > 0) {
            for (int i = 0; i < ext.length; ++i) {
                if (ext[i].getClassname() == null || ext[i].getClassname().length() == 0) continue;
                String[] required = ext[i].getRequiredPlugins();
                boolean ok = true;
                if (required != null && required.length > 0) {
                    for (String r : required) {
                        if (this.getManifestByName(r) != null) continue;
                        Logger.warn((String)("  skippging extension " + ext[i].getClassname() + ", requires plugin " + r));
                        ok = false;
                        break;
                    }
                }
                if (!ok) continue;
                try {
                    Class c = manifest.getClassLoader().load(ext[i].getClassname());
                    BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                    ExtensionRegistry.register((Extension)beanService.get(c), ext[i].getExtendableIDs());
                    Logger.info((String)("  register " + c.getName()));
                    continue;
                }
                catch (Exception e) {
                    Logger.error((String)("  unable to register extension " + ext[i].getClassname() + ", skipping"), (Throwable)e);
                }
            }
        }
        Application.getCallback().getStartupMonitor().addPercentComplete(5);
        manifest.setInstalled(true);
        Logger.info((String)("plugin " + manifest.getName() + " initialized successfully"));
    }

    public boolean isObsolete(String name) {
        return obsoletePlugins.contains(name);
    }

    public List<Plugin> getInstalledPlugins() {
        ArrayList<Plugin> l = new ArrayList<Plugin>();
        int size = this.plugins.size();
        for (int i = 0; i < size; ++i) {
            Manifest p = this.plugins.get(i);
            if (!p.isInstalled()) continue;
            l.add(p.getPluginInstance());
        }
        return l;
    }

    public List<Manifest> getInstalledManifests() {
        List<Manifest> all = this.getManifests();
        ArrayList<Manifest> installed = new ArrayList<Manifest>();
        for (int i = 0; i < all.size(); ++i) {
            Manifest p = this.plugins.get(i);
            if (!p.isInstalled()) continue;
            installed.add(p);
        }
        return installed;
    }

    public List<Manifest> getManifests() {
        return this.plugins;
    }

    public Manifest getManifest(Class plugin) {
        if (plugin == null) {
            return null;
        }
        return this.getManifest(plugin.getName());
    }

    public Manifest getManifest(String pluginClass) {
        if (pluginClass == null || pluginClass.length() == 0) {
            return null;
        }
        int size = this.plugins.size();
        Manifest mf = null;
        for (int i = 0; i < size; ++i) {
            mf = this.plugins.get(i);
            if (!mf.getPluginClass().equals(pluginClass)) continue;
            return mf;
        }
        return null;
    }

    public Manifest getManifestByName(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        int size = this.plugins.size();
        Manifest mf = null;
        for (int i = 0; i < size; ++i) {
            mf = this.plugins.get(i);
            if (!mf.getName().equals(name)) continue;
            return mf;
        }
        return null;
    }

    public <T extends Plugin> T getPlugin(Class<? extends Plugin> plugin) {
        if (plugin == null) {
            return null;
        }
        return (T)this.getPlugin(plugin.getName());
    }

    public Plugin getPlugin(String pluginClass) {
        if (pluginClass == null || pluginClass.length() == 0) {
            return null;
        }
        Manifest mf = this.getManifest(pluginClass);
        return mf == null ? null : mf.getPluginInstance();
    }

    public Plugin findByClass(Class c) {
        try {
            CodeSource source = c.getProtectionDomain().getCodeSource();
            if (source == null) {
                Logger.debug((String)("unable to determine code source of class " + c));
                return null;
            }
            URL url = source.getLocation();
            if (url == null) {
                Logger.debug((String)("unable to determine location of class " + c));
                return null;
            }
            File f = new File(url.toURI());
            String test = f.getCanonicalPath();
            List<Manifest> manifests = this.getManifests();
            for (int i = 0; i < manifests.size(); ++i) {
                String d;
                Manifest mf = manifests.get(i);
                File dir = new File(mf.getPluginDir());
                if (!dir.exists() || !test.startsWith(d = dir.getCanonicalPath())) continue;
                return mf.getPluginInstance();
            }
            Logger.debug((String)("unable to determine location of class " + c));
        }
        catch (Exception e) {
            Logger.error((String)("unable to determine location of class " + c), (Throwable)e);
        }
        return null;
    }

    public boolean isInstalled(String pluginClass) {
        if (pluginClass == null || pluginClass.length() == 0) {
            return false;
        }
        Manifest mf = this.getManifest(pluginClass);
        return mf != null && mf.isInstalled();
    }

    public void canUnInstall(Manifest mf) throws ApplicationException {
        I18N i18n = Application.getI18n();
        if (mf == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie das zu deinstallierende Plugin aus"));
        }
        try {
            PluginSourceService sources = (PluginSourceService)Application.getBootLoader().getBootable(PluginSourceService.class);
            PluginSource source = sources.getSource(mf.getPluginSource());
            if (source == null || !source.canWrite()) {
                throw new ApplicationException(i18n.tr("Plugin kann wegen fehlenden Schreib-Rechten nicht deinstalliert werden."));
            }
            List<Manifest> manifests = this.getInstalledManifests();
            for (Manifest m : manifests) {
                Dependency[] deps;
                if (m.getName().equals(mf.getName()) || (deps = m.getDirectDependencies()) == null) continue;
                for (Dependency dep : deps) {
                    String name = dep.getName();
                    if (!dep.isRequired() || name == null || !name.equals(mf.getName())) continue;
                    throw new ApplicationException(i18n.tr("Plugin {0} ben\u00f6tigt {1}", new String[]{name, mf.getName()}));
                }
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to perform uninstall check", (Throwable)e);
            throw new ApplicationException(i18n.tr("Plugin kann nicht deinstalliert werden: {0}", e.getMessage()));
        }
    }

    public void unInstall(final Manifest mf, boolean deleteUserData, ProgressMonitor monitor) {
        I18N i18n = Application.getI18n();
        try {
            this.canUnInstall(mf);
            String name = mf.getName();
            monitor.setStatusText(i18n.tr("Deinstalliere Plugin {0}", name));
            monitor.addPercentComplete(10);
            Logger.warn((String)("uninstalling plugin " + name));
            Plugin plugin = this.getPlugin(mf.getPluginClass());
            if (plugin != null && !Application.inServerMode()) {
                GUI.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MenuItemXml menu;
                            NavigationItemXml navi = (NavigationItemXml)mf.getNavigation();
                            if (navi != null) {
                                navi.setEnabled(false, true);
                            }
                            if ((menu = (MenuItemXml)mf.getMenu()) != null) {
                                menu.setEnabled(false, true);
                            }
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable to disable menu/navigation", (Throwable)e);
                        }
                    }
                });
                monitor.addPercentComplete(10);
            }
            if (plugin != null) {
                plugin.shutDown();
                plugin.uninstall(deleteUserData);
                monitor.addPercentComplete(10);
            }
            if (plugin != null) {
                Application.getServiceFactory().shutDown(plugin);
                monitor.addPercentComplete(10);
            }
            if (deleteUserData && plugin != null) {
                this.deleteConfigs(plugin);
                monitor.addPercentComplete(10);
                File dataDir = new File(plugin.getResources().getWorkPath());
                if (dataDir.exists()) {
                    FileUtil.deleteRecursive((File)dataDir);
                }
                monitor.addPercentComplete(10);
            }
            this.markForDelete(mf);
            monitor.addPercentComplete(10);
            if (deleteUserData) {
                this.updateChecker.setAttribute(mf.getPluginClass() + ".version", null);
                monitor.addPercentComplete(10);
            }
            this.plugins.remove(mf);
            monitor.addPercentComplete(10);
            monitor.setStatus(4);
            monitor.setPercentComplete(100);
            monitor.setStatusText(i18n.tr("Plugin deinstalliert"));
            Logger.warn((String)("plugin " + mf.getName() + " uninstalled"));
            Application.getMessagingFactory().sendMessage(new PluginMessage(mf, PluginMessage.Event.UNINSTALLED));
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Plugin deinstalliert, bitte starten Sie Jameica neu"), 0));
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e instanceof ApplicationException || e instanceof SecurityException) {
                msg = e.getMessage();
            } else {
                Logger.error((String)"unable to uninstall plugin", (Throwable)e);
                msg = i18n.tr("Fehler beim Deinstallieren: {0}", msg);
            }
            monitor.setStatus(3);
            monitor.setStatusText(msg);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(msg, 1));
        }
    }

    public Map<Manifest, Throwable> getInitErrors() {
        return this.initErrors;
    }

    public void markForDelete(Manifest manifest) throws ApplicationException {
        if (manifest == null) {
            return;
        }
        File dir = new File(manifest.getPluginDir());
        if (!dir.exists()) {
            return;
        }
        Logger.warn((String)"creating delete marker to cleanup on next restart");
        File deleteMarker = new File(dir, ".deletemarker");
        try {
            deleteMarker.createNewFile();
        }
        catch (IOException e) {
            Logger.error((String)("unable to create delete marker " + deleteMarker), (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("L\u00f6schen des Plugins {0} fehlgeschlagen: {1}", new String[]{manifest.getName(), e.getMessage()}));
        }
    }

    private void deleteConfigs(Plugin plugin) {
        File[] files;
        MultipleClassLoader loader = plugin.getManifest().getClassLoader();
        FileFinder finder = new FileFinder(new File(Application.getConfig().getConfigDir()));
        finder.extension(".properties");
        for (File f : files = finder.find()) {
            block4: {
                String name = f.getName();
                name = name.replaceAll("\\.properties$", "");
                try {
                    Class<?> c = loader.loadClass(name);
                    Plugin p = this.findByClass(c);
                    if (p == null) continue;
                    if (!p.getClass().equals(plugin.getClass())) {
                    }
                    break block4;
                }
                catch (Exception e) {
                    Logger.write((Level)Level.DEBUG, (String)("unable to determine plugin for file " + f), (Throwable)e);
                }
                continue;
            }
            Logger.info((String)("  " + f.getName()));
            if (f.delete()) continue;
            Logger.warn((String)("unable to delete " + f));
        }
    }

    public void shutDown() {
        Logger.info((String)"shutting down plugins");
        int size = this.plugins.size();
        for (int i = 0; i < size; ++i) {
            Manifest mf = this.plugins.get(i);
            if (!mf.isInstalled()) continue;
            Plugin plugin = mf.getPluginInstance();
            Logger.debug((String)plugin.getClass().getName());
            try {
                plugin.shutDown();
                continue;
            }
            catch (Exception e2) {
                Logger.error((String)"failed", (Throwable)e2);
            }
        }
        this.plugins.clear();
    }

    private static class QuickSort {
        private QuickSort() {
        }

        private static void swap(List list, int i, int j) {
            Object tmp = list.get(i);
            list.set(i, list.get(j));
            list.set(j, tmp);
        }

        private static void quickSort(List list) {
            if (list == null || list.size() < 2) {
                return;
            }
            QuickSort._quickSort(list, 0, list.size() - 1);
        }

        private static void _quickSort(List list, int left, int right) {
            if (right > left) {
                int index = left + (right - left) / 2;
                Manifest pivot = (Manifest)list.get(index);
                QuickSort.swap(list, index, right);
                for (int i = index = left; i < right; ++i) {
                    if (((Manifest)list.get(i)).compareTo(pivot) >= 0) continue;
                    QuickSort.swap(list, index++, i);
                }
                QuickSort.swap(list, index, right);
                QuickSort._quickSort(list, left, index);
                QuickSort._quickSort(list, index + 1, right);
            }
        }
    }
}

